<?php
//Exit if file called directly
if (!defined('ABSPATH')) {
    exit;
}

require_once(ABSPATH . 'wp-admin/includes/upgrade.php');


function check_table_data_exists_questions() {
    global $wpdb;
    $questions = $wpdb->get_results("SELECT count(1) AS total FROM `questions`", ARRAY_A);
    
    return $questions['total'];
}

function check_table_data_exists_class() {
    global $wpdb;
    $questions = $wpdb->get_results("SELECT count(1) AS total FROM `class`", ARRAY_A);
    
    return $questions['total'];
}

function check_table_data_exists_answer() {
    global $wpdb;
    $questions = $wpdb->get_results("SELECT count(1) AS total FROM `answers`", ARRAY_A);
    
    return $questions['total'];
}

function create_table_new() {

    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();
    $db_tb_name = $wpdb->prefix . 'users_new';

    $db_query = "
    
    CREATE TABLE `answers` (
    `answer` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The code for an answer to a question',
    `question` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The question the answer belongs to',
    `definition` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'The answer itself',
    `statement` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'The statement related to the answer',
    `class` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'The class the answer belongs to',
    `next_question` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Next question to ask based on answer'
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


    CREATE TABLE `class` (
    `class` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The class identifier',
    `definition` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'The definition for the statement of a class',
    `rank` smallint(6) DEFAULT NULL
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



    CREATE TABLE `questions` (
    `question` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique code for a question',
    `definition` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'The definition of the question, the question itself',
    `answer_type` smallint(6) DEFAULT 0 COMMENT 'Type of answers, 0 = multiple choice, 1 = single choice',
    `parent` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `child` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


    CREATE TABLE `users_results` (
    `result_id` int(11) NOT NULL,
    `result` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
    `customer` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
    `result_answer` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
    `is_finished` tinyint(1) NOT NULL,
    `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
    `statement_date` date NOT NULL,
    `unique_value` varchar(30) COLLATE utf8_bin NOT NULL,
    `complete_incomplete` tinyint(1) NOT NULL
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
 
";

    
    dbDelta($db_query);
}

function alter_user_tables() {

    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();
    $db_tb_name = $wpdb->prefix . 'users';


    $db_query_answers = "
    ALTER TABLE `answers`
    ADD PRIMARY KEY (`question`,`answer`),
    ADD KEY `next_question` (`next_question`),
    ADD KEY `class` (`class`),
    ADD KEY `answer` (`answer`)
        
        ";

    $db_query_class = "
    ALTER TABLE `class`
    ADD PRIMARY KEY (`class`)
        ";


    $db_query_users_results2 = "
  ALTER TABLE `users_results`
  ADD PRIMARY KEY (`result_id`);
        
        ";

    
    
     $db_query_users_increament = "
    ALTER TABLE `users_results`
    MODIFY `result_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=38;
        
        ";
    
    
    
    $db_query_questions = "
    ALTER TABLE `questions`
    ADD PRIMARY KEY (`question`);

    ";

    $db_query_users = "ALTER TABLE wp_users 
    ADD `Full_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL AFTER `display_name`,
    ADD `credits` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL AFTER `Full_name`,
    ADD `Adress1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL AFTER `credits`,
    ADD `Adress` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL AFTER `Adress1`,
    ADD `compnay` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL AFTER `Adress`;
 
    ";

    
    $wpdb->query($db_query_answers);
    $wpdb->query($db_query_class);
    $wpdb->query($db_query_users_results2);
    $wpdb->query($db_query_users_increament);
    $wpdb->query($db_query_questions);
    $wpdb->query($db_query_users);
    
    $questions = check_table_data_exists_questions();
    
    if($questions==0){
        $db_query_question_data = "INSERT INTO `questions` 
        (`question`, `definition`, `answer_type`, `parent`, `child`) VALUES
        ('Q1', 'The medical device duration of use?\r\n', 1, NULL, NULL),
        ('Q15', 'Is the active device therapeutic?\r\n', 1, NULL, NULL),
        ('Q2', 'Is the medical device:\r\n', 1, NULL, NULL),
        ('Q3', 'Is the medical device:  \r\n', 1, NULL, NULL),
        ('Q4', 'Is the medical device:   \r\n', 1, NULL, NULL),
        ('Q5', 'Does the medical device come into contact with injured skin or mucous membrane?\r\n', 1, NULL, NULL),
        ('Q6', 'Is the medical device that comes into contact with injured skin or mucous membrane:\r\n', 0, NULL, NULL);";
        $wpdb->query($db_query_question_data);
    }
    
    $class = check_table_data_exists_class();
    
    if($class==0){
        $db_query_class_data = "INSERT INTO `class` (`class`, `definition`, `rank`) VALUES
        ('Class I\r\n', 'Therefore classified as class I. \r\n', 1),
        ('Class IIa\r', 'Therefore classified as class IIa. \r\n', 2),
        ('Class IIb	', 'Therefore classified as class IIb. \r\n', 3),
        ('Class III\r', 'Therefore classified as class III. \r\n', 4);";
        $wpdb->query($db_query_class_data);
    }
    
    $answer = check_table_data_exists_answer();
    
    if($answer==0){
        $db_query_answer_data = "INSERT INTO `answers` (`answer`, `question`, `definition`, `statement`, `class`, `next_question`) VALUES
        ('A', 'Q1', 'Transient - Normally intended for continuous use for less than 60 minutes.', 'The Medical device is intended for transient use, which means it is to be normally intended for continuous use for less than 60 minutes.\r\n', '', 'Q2'),
        ('B', 'Q1', 'Short term - Normally intended for continuous use for between 60 minutes and 30 days.', ' The Medical device is intended for short-term use, which means it is to be normally intended for continuous use for between 60 minutes and 30 days.', '', 'Q2'),
        ('C', 'Q1', 'Long Term - Normally intended for continuous use for more than 30 days.', 'The Medical device is intended for long-term use, which means it is to be normally intended for continuous use for more than 30 days.', '', 'Q2'),
        ('A', 'Q15', 'YES', 'The active device is therapeutic.', '', ''),
        ('B', 'Q15', 'NO', '', '', ''),
        ('A', 'Q2', 'Non-invasive.', 'The medical device is non-invasive.\r\n', '', 'Q3'),
        ('B', 'Q2', 'Invasive. - Any device which, in whole or in part, penetrates inside the body, either through a body orifice or through the surface of the body.', 'The medical device is invasive, which means the device whole or in part, penetrates inside the body, either through a body orifice or through the surface of the body.', NULL, 'Q6'),
        ('C', 'Q2', 'Active. Any device, the operation of which depends on a source of energy other than that generated by the human body for that purpose, or by gravity, and which acts by changing the density of or converting that energy. Devices intended to transmit energy, substances or other elements between an active device and the patient, without any significant change, shall not be deemed to be active devices. Software shall also be deemed to be an active device.', 'The medical device is active, which means the device, the operation of which depends on a source of energy other than that generated by the human body for that purpose, or by gravity, and which acts by changing the density of or converting that energy. Devices intended to transmit energy, substances or other elements between an active device and the patient, without any significant change, shall not be deemed to be active devices. Software shall also be deemed to be an active device.', '', 'Q15'),
        ('A', 'Q3', '— intended for channelling or storing blood, body liquids, cells or tissues, liquids or gases for the purpose of eventual infusion, administration or introduction into the body?', 'The medical device is intended for channelling or storing blood, body liquids, cells or tissues, liquids or gases for the purpose of eventual infusion, administration or introduction into the body.    ', '2', 'Q4'),
        ('B', 'Q3', '— connected or may it be connected to a class IIa, class IIb or class III active device?', 'The medical device is connected or may it be connected to a class IIa, class IIb or class III active device.  ', '3', 'Q4'),
        ('C', 'Q3', '— intended for use for channelling or storing blood or other body liquids or for storing organs, parts of organs or body cells and tissues, except for blood bags; blood bags?', 'The medical device is intended for use for channelling or storing blood or other body liquids or for storing organs, parts of organs or body cells and tissues, except for blood bags; blood bags.  ', '3', 'Q4'),
        ('D', 'Q3', '— NOT intended for use described in A, B and C?', 'The medical device is:  —    NOT intended for channelling or storing blood, body liquids, cells or tissues, liquids or gases for the purpose of eventual infusion, administration or introduction into the body,  —   NOT connected or may it be connected to a class IIa, class IIb or class III active device,  —   NOT intended for use for channelling or storing blood or other body liquids or for storing organs, parts of organs or body cells and tissues, except for blood bags; blood bags. ', '1', 'Q4'),
        ('A', 'Q4', '— intended for modifying the biological or chemical composition of human tissues or cells, blood, other body liquids or other liquids intended for implantation or administration into the body?', 'The medical device is intended for modifying the biological or chemical composition of human tissues or cells, blood, other body liquids or other liquids intended for implantation or administration into the body.  ', '3', 'Q5'),
        ('B', 'Q4', '— intended for modifying the biological or chemical composition of human tissues or cells, blood, other body liquids or other liquids intended for implantation or administration into the body in a treatment for which the device is used consists of filtration, centrifugation or exchanges of gas, heat?', 'The medical device is intended for modifying the biological or chemical composition of human tissues or cells, blood, other body liquids or other liquids intended for implantation or administration into the body in a treatment for which the device is used consists of filtration, centrifugation or exchanges of gas, heat.  ', '2', 'Q5'),
        ('C', 'Q4', '— consisting of a substance or a mixture of substances intended to be used in vitro in direct contact with human cells, tissues or organs taken from the human body or used in vitro with human embryos before their implantation or administration into the body?', 'The medical device is consisting of a substance or a mixture of substances intended to be used in vitro in direct contact with human cells, tissues or organs taken from the human body or used in vitro with human embryos before their implantation or administration into the body.  ', '4', 'Q5'),
        ('A', 'Q5', 'YES', 'The medical device come into contact with injured skin or mucous membrane.', '', ''),
        ('B', 'Q5', 'NO', '', '', ''),
        ('A', 'Q6', '—  intended to be used as a mechanical barrier, for compression or for absorption of exudates?', 'The medical device that comes into contact with injured skin or mucous membrane is intended to be used as a mechanical barrier, for compression or for absorption of exudates.  ', '1', ''),
        ('B', 'Q6', '—  intended to be used principally for injuries to skin which have breached the dermis or mucous membrane and can only heal by secondary intent?', 'The medical device that comes into contact with injured skin or mucous membrane is intended to be used principally for injuries to skin which have breached the dermis or mucous membrane and can only heal by secondary intent.  ', '3', ''),
        ('C', 'Q6', '—  intended principally to manage the micro-environment of injured skin or mucous membrane?', 'The medical device that comes into contact with injured skin or mucous membrane is intended principally to manage the micro-environment of injured skin or mucous membrane.  ', '2', ''),
        ('D', 'Q6', '— NOT intended for use described in A, B and C? (All other cases)', 'A.     The medical device that comes into contact with injured skin or mucous membrane is: —   NOT intended to be used as a mechanical barrier, for compression or for absorption of exudates. —   NOT intended to be used principally for injuries to skin which have breached the dermis or mucous membrane and can only heal by secondary intent, —   NOT intended principally to manage the micro-environment of injured skin or mucous membrane.', '2', '');";
        $wpdb->query($db_query_answer_data);
    }
    
}
